#import "MysteryBox.h"

@implementation MysteryBox

//init a new object but pre-populate its contents
-(id) initWithContents:(NSString *)contents
{
	//call NSObject init
	[super init];
	
	//set my contents
	[self setContents:contents];
	
	//because setContents increments the retain count we need to call release
	//to balance it out
	[contents release];
	
	//return pointer to this object
	return self;
}

//set the contents of the box
-(void) setContents:(NSString *)contents
{
	//make sure we call retain on the param so this 
	//can't be freed accidentally on us
	[contents retain];
	
	//store the contents
	myContents = contents;
}

//return the contents of the box
-(NSString *) getContents
{
	return myContents;
}

//free up all memory
-(void) dealloc
{
	[myContents release];
	[super dealloc];
}

@end
