#import "Person.h"

@implementation Person

//initialize the object with the name of the person and the box
-(id) initWithNameAndBox:(NSString *)theName theBox:(MysteryBox *)box
{
	//call parent init
	[super init];

	//make sure we call retain on the params so these 
	//can't be freed accidentally on us
	[theName retain];
	[box retain];
	
	//store the name
	myName = theName;

	//store the box
	myBox = box;
	
	//return pointer to this object
	return self;
}

//print out info about person
-(void) myInfo
{
	NSLog(@"My name is: %@\n", myName);
	NSLog(@"My mystery box holds: %@\n",[myBox getContents]);
	
}

//free up all memory
-(void) dealloc
{
	[myName release];
	[myBox release];
	[super dealloc];
}

@end
