#import <Foundation/Foundation.h>
#import "Person.h"
#import "MysteryBox.h"

/*
 *this program demonstrates a number of different ways to accomplish the same 
 *thing within objective-c. Please keep in mind that this is not the best way 
 *to do things. For example rather than calling retain on random parameters it
 *is safer to create local copies. Also the main function should really be calling
 *autorelease on everything it allocs just so we don't leak memory. The only reason
 *I didn't is because I know the objects will release it themselves
 */
int main(void)
{
	//create a box for the first person
	MysteryBox *b1 = [[MysteryBox alloc] init];
	
	//create a temporary string for its contents
	NSString *tmp = [[NSString alloc] initWithString:@"gold!"];
	
	//pass the temporary string to the box
	[b1 setContents:tmp];
	
	//free the memory
	//this will actually only decrement the reference count and not free
	//it because we call retain in setContents
	[tmp release];
	
	//create a new person using inline string creation
	//also pass in the box we created above
	Person *p1 = [[Person alloc] initWithNameAndBox:@"John Smith" theBox:b1];
	
	//free the box reference
	[b1 release];
	
	//print out information about the person
	[p1 myInfo];
	
	//free all of the object's memory
	[p1 release];
	
	//demonstrate doing all of the above inline
	Person *p2 = [[Person alloc] initWithNameAndBox:@"Jane Smith" theBox:[[MysteryBox alloc] initWithContents:@"nothing :("]];
	
	//print out information about the person
	[p2 myInfo];
	
	//free the object's memory
	[p2 release];
	
	//return success
	return 0;
}
