/*
 * CGTKSeparatorToolItem.m
 * This file is part of CoreGTK
 *
 * Copyright (C) 2014 - Tyler Burton
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * Modified by the CoreGTK Team, 2014. See the AUTHORS file for a
 * list of people on the CoreGTK Team.
 * See the ChangeLog files for a list of changes.
 *
 */

#import "CGTKSeparatorToolItem.h"

@implementation CGTKSeparatorToolItem

-(GtkSeparatorToolItem *)SEPARATOR_TOOL_ITEM
{
	return GTK_SEPARATOR_TOOL_ITEM([self WIDGET]);
}

-(id)init
{
	self = [super initWithGtkWidget:GTK_WIDGET(gtk_separator_tool_item_new ()) andIncrementRefCount:NO];

	if(self)
	{

	}

	return self;
}

-(BOOL)getDraw
{
	return [CGTK getBOOL:gtk_separator_tool_item_get_draw ([self SEPARATOR_TOOL_ITEM])];
}

-(void)setDraw:(BOOL)draw
{
	gtk_separator_tool_item_set_draw ([self SEPARATOR_TOOL_ITEM], [CGTK getGboolean:draw]);
}

@end
