/*
 * AppDelegate.m
 *
 * Copyright (C) 2015 - Tyler Burton
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * Objective-C imports
 */
#import "AppDelegate.h"

@implementation AppDelegate

@synthesize textField;
@synthesize slider;
@synthesize track;

/* Callbacks */
-(void)mute
{
	if(!updateInProgress)
	{
		updateInProgress = YES;
		
		[self.track setVolume:0.0];
	
		[self updateUserInterface];
		
		updateInProgress = NO;
	}
}

-(void)sliderChanged
{
	if(!updateInProgress)
	{
		updateInProgress = YES;
		
		[self.track setVolume:[self.slider getValue]];
	
		[self updateUserInterface];
		
		updateInProgress = NO;
	}
}

-(void)takeValueForVolume
{
	NSString *text = [self.textField getText];
	if([text length] == 0)
	{
		return;
	}
	
	if(!updateInProgress)
	{
		updateInProgress = YES;
		
		double newValue = [[self.textField getText] doubleValue];
	
		[self.track setVolume:newValue];
	
		[self updateUserInterface];
		
		updateInProgress = NO;
	}
}

/* Methods */
-(void)updateUserInterface
{
	double volume = [self.track volume];
	
	[self.textField setText:[NSString stringWithFormat:@"%1.0f", volume]];
	
	[self.slider setValue:volume];
}

-(void)dealloc
{
	[textField release];
	[slider release];
	[track release];
	[super dealloc];
}

@end
