/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer;

import com.sun.jna.Pointer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gstreamer.Element;
import org.gstreamer.GstObject;
import org.gstreamer.PluginFeature;
import org.gstreamer.StaticPadTemplate;
import org.gstreamer.elements.AppSink;
import org.gstreamer.elements.AppSrc;
import org.gstreamer.elements.DecodeBin;
import org.gstreamer.elements.FakeSink;
import org.gstreamer.elements.FakeSrc;
import org.gstreamer.elements.FileSrc;
import org.gstreamer.elements.PlayBin;
import org.gstreamer.elements.TypeFind;
import org.gstreamer.lowlevel.GlibAPI;
import org.gstreamer.lowlevel.GstCapsAPI;
import org.gstreamer.lowlevel.GstElementFactoryAPI;
import org.gstreamer.lowlevel.GstNative;
import org.gstreamer.lowlevel.GstPadTemplateAPI;
import org.gstreamer.lowlevel.GstTypes;
import org.gstreamer.lowlevel.NativeObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementFactory
extends PluginFeature {
    private static Logger logger = Logger.getLogger(ElementFactory.class.getName());
    private static final API gst = GstNative.load(API.class);
    static Level DEBUG = Level.FINE;
    private static final Map<String, Class<? extends Element>> typeMap = new HashMap<String, Class<? extends Element>>(){
        {
            this.put("playbin", PlayBin.class);
            this.put("decodebin", DecodeBin.class);
            this.put("typefind", TypeFind.class);
            this.put("fakesrc", FakeSrc.class);
            this.put("fakesink", FakeSink.class);
            this.put("filesrc", FileSrc.class);
            this.put("appsrc", AppSrc.class);
            this.put("appsink", AppSink.class);
        }
    };

    public ElementFactory(NativeObject.Initializer init) {
        super(init);
        logger.entering("ElementFactory", "<init>", new Object[]{init});
    }

    public Element create(String name) {
        logger.entering("ElementFactory", "create", name);
        Pointer elem = gst.ptr_gst_element_factory_create(this, name);
        logger.log(DEBUG, "gst_element_factory_create returned: " + elem);
        if (elem == null) {
            throw new IllegalArgumentException("Cannot create GstElement");
        }
        return ElementFactory.elementFor(elem, this.getName());
    }

    public String getAuthor() {
        logger.entering("ElementFactory", "getAuthor");
        return gst.gst_element_factory_get_author(this);
    }

    public String getDescription() {
        logger.entering("ElementFactory", "getDescription");
        return gst.gst_element_factory_get_description(this);
    }

    public String getLongName() {
        logger.entering("ElementFactory", "getLongName");
        return gst.gst_element_factory_get_longname(this);
    }

    public String getKlass() {
        logger.entering("ElementFactory", "getKlass");
        return gst.gst_element_factory_get_klass(this);
    }

    public List<StaticPadTemplate> getStaticPadTemplates() {
        GlibAPI.GList glist = gst.gst_element_factory_get_static_pad_templates(this);
        ArrayList<StaticPadTemplate> templates = new ArrayList<StaticPadTemplate>();
        for (GlibAPI.GList next = glist; next != null; next = next.next()) {
            if (next.data == null) continue;
            GstPadTemplateAPI.GstStaticPadTemplate temp = new GstPadTemplateAPI.GstStaticPadTemplate(next.data);
            templates.add(new StaticPadTemplate(temp.name_template, temp.direction, temp.presence, gst.gst_static_caps_get(temp.static_caps)));
        }
        return templates;
    }

    public static ElementFactory find(String name) {
        logger.entering("ElementFactory", "find", name);
        ElementFactory factory = gst.gst_element_factory_find(name);
        if (factory == null) {
            throw new IllegalArgumentException("No such Gstreamer factory: " + name);
        }
        return factory;
    }

    public static Element make(String factoryName, String name) {
        logger.entering("ElementFactory", "make", new Object[]{factoryName, name});
        return ElementFactory.elementFor(ElementFactory.makeRawElement(factoryName, name), factoryName);
    }

    static Pointer makeRawElement(String factoryName, String name) {
        logger.entering("ElementFactory", "makeRawElement", new Object[]{factoryName, name});
        Pointer elem = gst.ptr_gst_element_factory_make(factoryName, name);
        logger.log(DEBUG, "Return from gst_element_factory_make=" + elem);
        if (elem == null) {
            throw new IllegalArgumentException("No such Gstreamer factory: " + factoryName);
        }
        return elem;
    }

    private static Element elementFor(Pointer ptr, String factoryName) {
        Class<? extends Element> cls = typeMap.get(factoryName);
        cls = cls == null ? GstTypes.classFor(ptr) : cls;
        cls = cls == null || !Element.class.isAssignableFrom(cls) ? Element.class : cls;
        return GstObject.objectFor(ptr, cls);
    }

    private static interface API
    extends GstElementFactoryAPI,
    GstCapsAPI,
    GstPadTemplateAPI {
    }
}

