/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer;

import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gstreamer.ExecutorServiceTest;
import org.gstreamer.Gst;
import org.gstreamer.lowlevel.MainLoop;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ExecutorServiceTest {
    private static MainLoop loop;

    @BeforeClass
    public static void setUpClass() throws Exception {
        Gst.init("ExecutorServiceTest", new String[0]);
        loop = new MainLoop();
        loop.startInBackground();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        loop.quit();
        Gst.deinit();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void execute() {
        TestExec exec = new TestExec(null);
        exec.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        exec.run();
        Assert.assertTrue((String)"Runnable not called", (boolean)exec.hasFired());
    }

    @Test
    public void submit() throws Exception {
        TestExec exec = new TestExec(null);
        Integer MAGIC = -559038737;
        2 callable = new /* Unavailable Anonymous Inner Class!! */;
        Future f = exec.exec.submit(callable);
        exec.run();
        Assert.assertTrue((String)"Callable not called", (boolean)exec.hasFired());
        Assert.assertEquals((String)"Wrong value returned from Callable", (Object)MAGIC, f.get());
    }

    @Test
    public void oneShotTimeout() {
        TestExec exec = new TestExec(null);
        exec.exec.schedule((Runnable)new /* Unavailable Anonymous Inner Class!! */, 100L, TimeUnit.MILLISECONDS);
        exec.run();
        Assert.assertTrue((String)"Runnable not called", (boolean)exec.hasFired());
    }

    @Test
    public void timeoutWithReturnValue() throws Exception {
        TestExec exec = new TestExec(null);
        Integer MAGIC = -559038737;
        4 callable = new /* Unavailable Anonymous Inner Class!! */;
        ScheduledFuture f = exec.exec.schedule(callable, 100L, TimeUnit.MILLISECONDS);
        exec.run();
        Assert.assertTrue((String)"Runnable not called", (boolean)exec.hasFired());
        Assert.assertEquals((String)"Wrong value returned from Callable", (Object)MAGIC, f.get());
    }

    @Test
    public void periodicTimeout() {
        TestExec exec = new TestExec(null);
        AtomicBoolean called = new AtomicBoolean(false);
        exec.exec.scheduleAtFixedRate((Runnable)new /* Unavailable Anonymous Inner Class!! */, 10L, 10L, TimeUnit.MILLISECONDS);
        exec.run();
        Assert.assertTrue((String)"Runnable not called", (boolean)exec.hasFired());
    }
}

