/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.query;

import com.sun.jna.Library;
import com.sun.jna.Pointer;
import org.gstreamer.ClockTime;
import org.gstreamer.Query;
import org.gstreamer.lowlevel.GstNative;
import org.gstreamer.lowlevel.NativeObject;

public class LatencyQuery
extends Query {
    private static final API gst = GstNative.load(API.class);

    public LatencyQuery(NativeObject.Initializer init) {
        super(init);
    }

    public LatencyQuery() {
        super(LatencyQuery.initializer(gst.ptr_gst_query_new_latency()));
    }

    public void setLatency(boolean live, ClockTime minLatency, ClockTime maxLatency) {
        gst.gst_query_set_latency(this, live, minLatency, maxLatency);
    }

    public boolean isLive() {
        boolean[] live = new boolean[1];
        gst.gst_query_parse_latency(this, live, null, null);
        return live[0];
    }

    public ClockTime getMinimumLatency() {
        ClockTime[] latency = new ClockTime[1];
        gst.gst_query_parse_latency(this, null, latency, null);
        return latency[0];
    }

    public ClockTime getMaximumLatency() {
        ClockTime[] latency = new ClockTime[1];
        gst.gst_query_parse_latency(this, null, null, latency);
        return latency[0];
    }

    public String toString() {
        return String.format("latency:[live=%b, min=%s, max=%s]", this.isLive(), this.getMinimumLatency(), this.getMaximumLatency());
    }

    private static interface API
    extends Library {
        public Pointer ptr_gst_query_new_latency();

        public void gst_query_set_latency(Query var1, boolean var2, ClockTime var3, ClockTime var4);

        public void gst_query_parse_latency(Query var1, boolean[] var2, ClockTime[] var3, ClockTime[] var4);
    }
}

