/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer;

import com.sun.jna.Pointer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.gstreamer.Buffer;
import org.gstreamer.Bus;
import org.gstreamer.Caps;
import org.gstreamer.Clock;
import org.gstreamer.ClockTime;
import org.gstreamer.ElementFactory;
import org.gstreamer.Event;
import org.gstreamer.GstIterator;
import org.gstreamer.GstObject;
import org.gstreamer.Message;
import org.gstreamer.Pad;
import org.gstreamer.State;
import org.gstreamer.StateChangeReturn;
import org.gstreamer.lowlevel.GObjectAPI;
import org.gstreamer.lowlevel.GstAPI;
import org.gstreamer.lowlevel.GstElementAPI;
import org.gstreamer.lowlevel.GstNative;
import org.gstreamer.lowlevel.NativeObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Element
extends GstObject {
    private static final GstElementAPI gst = GstNative.load(GstElementAPI.class);
    private static Logger logger = Logger.getLogger(Element.class.getName());

    public Element(NativeObject.Initializer init) {
        super(init);
    }

    protected static NativeObject.Initializer makeRawElement(String factoryName, String elementName) {
        return Element.initializer(ElementFactory.makeRawElement(factoryName, elementName));
    }

    public boolean link(Element dest) {
        return gst.gst_element_link(this, dest);
    }

    public boolean link(Element ... elems) {
        Element[] list = new Element[elems.length + 1];
        list[0] = this;
        System.arraycopy(elems, 0, list, 1, elems.length);
        return Element.linkMany(list);
    }

    public void unlink(Element dest) {
        gst.gst_element_unlink(this, dest);
    }

    public StateChangeReturn setState(State state) {
        return gst.gst_element_set_state(this, state);
    }

    public void setCaps(Caps caps) {
        GObjectAPI.GOBJECT_API.g_object_set(this, "caps", caps);
    }

    @Deprecated
    public Pad getPad(String padname) {
        return gst.gst_element_get_static_pad(this, padname);
    }

    public Pad getStaticPad(String padname) {
        return gst.gst_element_get_static_pad(this, padname);
    }

    public List<Pad> getPads() {
        return new GstIterator<Pad>(gst.gst_element_iterate_pads(this), Pad.class).asList();
    }

    public List<Pad> getSrcPads() {
        return new GstIterator<Pad>(gst.gst_element_iterate_src_pads(this), Pad.class).asList();
    }

    public List<Pad> getSinkPads() {
        return new GstIterator<Pad>(gst.gst_element_iterate_sink_pads(this), Pad.class).asList();
    }

    public boolean addPad(Pad pad) {
        return gst.gst_element_add_pad(this, pad);
    }

    public Pad getRequestPad(String name) {
        return gst.gst_element_get_request_pad(this, name);
    }

    public void releaseRequestPad(Pad pad) {
        gst.gst_element_release_request_pad(this, pad);
    }

    public boolean removePad(Pad pad) {
        return gst.gst_element_remove_pad(this, pad);
    }

    public State getState() {
        return this.getState(-1L);
    }

    public State getState(long timeout, TimeUnit units) {
        State[] state = new State[1];
        gst.gst_element_get_state(this, state, null, units.toNanos(timeout));
        return state[0];
    }

    public State getState(long timeout) {
        State[] state = new State[1];
        gst.gst_element_get_state(this, state, null, timeout);
        return state[0];
    }

    public void getState(long timeout, State[] states) {
        State[] state = new State[1];
        State[] pending = new State[1];
        gst.gst_element_get_state(this, state, pending, timeout);
        states[0] = state[0];
        states[1] = pending[0];
    }

    public boolean syncStateWithParent() {
        return gst.gst_element_sync_state_with_parent(this);
    }

    public ElementFactory getFactory() {
        return gst.gst_element_get_factory(this);
    }

    public Bus getBus() {
        return gst.gst_element_get_bus(this);
    }

    public boolean sendEvent(Event ev) {
        return gst.gst_element_send_event(this, ev);
    }

    public void connect(final PAD_ADDED listener) {
        this.connect(PAD_ADDED.class, listener, new GstAPI.GstCallback(){

            public void callback(Element elem, Pad pad, Pointer user_data) {
                listener.padAdded(elem, pad);
            }
        });
    }

    public void disconnect(PAD_ADDED listener) {
        this.disconnect(PAD_ADDED.class, listener);
    }

    public void connect(final PAD_REMOVED listener) {
        this.connect(PAD_REMOVED.class, listener, new GstAPI.GstCallback(){

            public void callback(Element elem, Pad pad, Pointer user_data) {
                listener.padRemoved(elem, pad);
            }
        });
    }

    public void disconnect(PAD_REMOVED listener) {
        this.disconnect(PAD_REMOVED.class, listener);
    }

    public void connect(final NO_MORE_PADS listener) {
        this.connect(NO_MORE_PADS.class, listener, new GstAPI.GstCallback(){

            public void callback(Element elem, Pointer user_data) {
                listener.noMorePads(elem);
            }
        });
    }

    public void disconnect(NO_MORE_PADS listener) {
        this.disconnect(NO_MORE_PADS.class, listener);
    }

    public void connect(final HANDOFF listener) {
        this.connect(HANDOFF.class, listener, new GstAPI.GstCallback(){

            public void callback(Pointer src, Buffer buffer, Pad pad, Pointer user_data) {
                listener.handoff(Element.this, buffer, pad);
            }
        });
    }

    public void disconnect(HANDOFF listener) {
        this.disconnect(HANDOFF.class, listener);
    }

    public static boolean linkMany(Element ... elements) {
        return gst.gst_element_link_many(elements);
    }

    public static void unlinkMany(Element ... elements) {
        gst.gst_element_unlink_many(elements);
    }

    public static boolean linkPads(Element src, String srcPadName, Element dest, String destPadName) {
        return gst.gst_element_link_pads(src, srcPadName, dest, destPadName);
    }

    public static boolean linkPadsFiltered(Element src, String srcPadName, Element dest, String destPadName, Caps caps) {
        return gst.gst_element_link_pads_filtered(src, srcPadName, dest, destPadName, caps);
    }

    public static void unlinkPads(Element src, String srcPadName, Element dest, String destPadName) {
        gst.gst_element_unlink_pads(src, srcPadName, dest, destPadName);
    }

    public boolean postMessage(Message message) {
        return gst.gst_element_post_message(this, message);
    }

    public Clock getClock() {
        return gst.gst_element_get_clock(this);
    }

    public ClockTime getBaseTime() {
        return gst.gst_element_get_base_time(this);
    }

    public static interface HANDOFF {
        public void handoff(Element var1, Buffer var2, Pad var3);
    }

    public static interface NO_MORE_PADS {
        public void noMorePads(Element var1);
    }

    public static interface PAD_REMOVED {
        public void padRemoved(Element var1, Pad var2);
    }

    public static interface PAD_ADDED {
        public void padAdded(Element var1, Pad var2);
    }
}

