/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer;

import java.lang.ref.WeakReference;
import org.gstreamer.Bus;
import org.gstreamer.Gst;
import org.gstreamer.Pipeline;
import org.gstreamer.lowlevel.GObjectAPI;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PipelineTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
        Gst.init("PipelineTest", new String[0]);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        Gst.deinit();
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    public boolean waitGC(WeakReference<? extends Object> ref) throws InterruptedException {
        System.gc();
        for (int i = 0; ref.get() != null && i < 20; ++i) {
            Thread.sleep(10L);
            System.gc();
        }
        return ref.get() == null;
    }

    public boolean waitRefCnt(GObjectAPI.GObjectStruct struct, int refcnt) throws InterruptedException {
        System.gc();
        struct.read();
        for (int i = 0; struct.ref_count != refcnt && i < 20; ++i) {
            Thread.sleep(10L);
            System.gc();
            struct.read();
        }
        return struct.ref_count == refcnt;
    }

    @Test
    public void testBusGC() throws Exception {
        Pipeline pipe = new Pipeline("test playbin");
        pipe.play();
        Bus bus = pipe.getBus();
        GObjectAPI.GObjectStruct struct = new GObjectAPI.GObjectStruct(bus);
        int refcnt = struct.ref_count;
        Assert.assertTrue((refcnt > 1 ? 1 : 0) != 0);
        Bus bus2 = pipe.getBus();
        Assert.assertTrue((String)"Did not get same Bus object", (bus == bus2 ? 1 : 0) != 0);
        struct.read();
        Assert.assertEquals((String)"ref_count not equal", (long)refcnt, (long)struct.ref_count);
        bus2 = null;
        WeakReference<Bus> bref = new WeakReference<Bus>(bus);
        bus = null;
        Assert.assertFalse((String)"bus disposed prematurely", (boolean)this.waitGC(bref));
        Assert.assertFalse((String)"ref_count decremented prematurely", (boolean)this.waitRefCnt(struct, refcnt - 1));
        WeakReference<Pipeline> pref = new WeakReference<Pipeline>(pipe);
        pipe.stop();
        bus = pipe.getBus();
        bref = new WeakReference<Bus>(bus);
        pipe = null;
        Assert.assertTrue((String)"pipe not disposed", (boolean)this.waitGC(pref));
        struct.read();
        System.out.println("bus ref_count=" + struct.ref_count);
        bus = null;
        Assert.assertTrue((String)"bus not disposed", (boolean)this.waitGC(bref));
        Assert.assertTrue((String)"ref_count not decremented", (boolean)this.waitRefCnt(struct, 0));
    }

    @Test
    public void testLaunch() {
        Pipeline pipeline = Pipeline.launch("fakesrc ! fakesink");
        Assert.assertNotNull((String)"Pipeline not created", (Object)pipeline);
    }

    @Test
    public void testLaunchElementCount() {
        Pipeline pipeline = Pipeline.launch("fakesrc ! fakesink");
        Assert.assertEquals((String)"Number of elements in pipeline incorrect", (long)2L, (long)pipeline.getElements().size());
    }

    @Test
    public void testLaunchSrcElement() {
        Pipeline pipeline = Pipeline.launch("fakesrc ! fakesink");
        Assert.assertEquals((String)"First element not a fakesrc", (Object)"fakesrc", (Object)pipeline.getSources().get(0).getFactory().getName());
    }

    @Test
    public void testLaunchSinkElement() {
        Pipeline pipeline = Pipeline.launch("fakesrc ! fakesink");
        Assert.assertEquals((String)"First element not a fakesink", (Object)"fakesink", (Object)pipeline.getSinks().get(0).getFactory().getName());
    }

    @Test
    public void testVarargLaunch() {
        Pipeline pipeline = Pipeline.launch("fakesrc", "fakesink");
        Assert.assertNotNull((String)"Pipeline not created", (Object)pipeline);
    }

    @Test
    public void testVarargLaunchElementCount() {
        Pipeline pipeline = Pipeline.launch("fakesrc", "fakesink");
        Assert.assertEquals((String)"Number of elements in pipeline incorrect", (long)2L, (long)pipeline.getElements().size());
    }

    @Test
    public void testVarargLaunchSrcElement() {
        Pipeline pipeline = Pipeline.launch("fakesrc", "fakesink");
        Assert.assertEquals((String)"First element not a fakesrc", (Object)"fakesrc", (Object)pipeline.getSources().get(0).getFactory().getName());
    }

    @Test
    public void testVarargLaunchSinkElement() {
        Pipeline pipeline = Pipeline.launch("fakesrc", "fakesink");
        Assert.assertEquals((String)"First element not a fakesink", (Object)"fakesink", (Object)pipeline.getSinks().get(0).getFactory().getName());
    }
}

