/*
 * MainWindow.h
 * Author: Tyler Burton
 * Website: www.tylerburton.ca
 */

#import <gtk/gtk.h>
#import <Foundation/NSObject.h>
#import <Foundation/NSString.h>

//A pointer to this object (set on init) so C functions can call 
//Objective-C functions
id myMainWindow;

/*
 * This class is responsible for initializing the GTK render loop
 * as well as setting up the GUI for the user. It also handles all GTK
 * callbacks for the winMain GtkWindow.
 */
@interface MainWindow : NSObject
{
	//The main GtkWindow
	GtkWidget *winMain;
	GtkWidget *button;
}

/*
 * Constructs the object and initializes GTK and the GUI for the 
 * application.
 *
 * **************************************************************************
 * Input
 * **************************************************************************
 * argc (int *):	A pointer to the arg count variable that was passed 
 * 			in at the application start. It will be returned 
 *			with the count of the modified argv array.
 * argv (char *[]): 	A pointer to the argument array that was passed in 
 *			at the application start. It will be returned with 
 *			the GTK arguments removed.
 *
 * **************************************************************************
 * Returns
 * **************************************************************************
 * MainWindow (id):	The constructed object or nil
 * arc (int *):		The modified input int as described above
 * argv (char *[]):	The modified input array modified as described above
 */
-(id)initWithArgCount:(int *)argc andArgVals:(char *[])argv;

/*
 * Frees the Gtk widgets that we have control over
 */
-(void)destroyWidget;

/*
 * Starts and hands off execution to the GTK main loop
 */
-(void)startGtkMainLoop;

/*
 * Example Objective-C function that prints some output
 */
-(void)printSomething;

/*
 ********************************************************
 * C callback functions
 ********************************************************
 */

/*
 * Called when the user closes the window
 */
void on_MainWindow_destroy(GtkObject *object, gpointer user_data);

/*
 * Called when the user presses the button
 */
void on_btnPushMe_clicked(GtkObject *object, gpointer user_data);

@end
