/*
 * MainWindow.m
 * Author: Tyler Burton
 * Website: www.tylerburton.ca
 */

#import "MainWindow.h"

/*
 * For documentation see MainWindow.h
 */

@implementation MainWindow

-(id)initWithArgCount:(int *)argc andArgVals:(char *[])argv
{
	//call parent class' init
	if (self = [super init]) {

		//setup the window
		winMain = gtk_window_new (GTK_WINDOW_TOPLEVEL);

		gtk_window_set_title (GTK_WINDOW (winMain), "Hello World");	
		gtk_window_set_default_size(GTK_WINDOW(winMain), 230, 150);

		//setup the button
		button = gtk_button_new_with_label ("Push me!");

		gtk_container_add (GTK_CONTAINER (winMain), button);

		//connect the signals
		g_signal_connect (winMain, "destroy", G_CALLBACK (on_MainWindow_destroy), NULL);
		g_signal_connect (button, "clicked", G_CALLBACK (on_btnPushMe_clicked), NULL);

		//force show all
		gtk_widget_show_all(winMain);
	}

	//assign C-compatible pointer
	myMainWindow = self;

	//return pointer to this object
	return self;
}

-(void)startGtkMainLoop
{
	//start gtk loop	
	gtk_main();
}

-(void)printSomething{
	NSLog(@"Printed from Objective-C's NSLog function.");
	printf("Also printed from standard printf function.\n");
}

-(void)destroyWidget{

	myMainWindow = NULL;

	if(GTK_IS_WIDGET (button))
	{	
		//clean up the button
		gtk_widget_destroy(button);
	}

	if(GTK_IS_WIDGET (winMain))
	{	
		//clean up the main window
		gtk_widget_destroy(winMain);
	}
}

-(void)dealloc{
	[self destroyWidget];

	[super dealloc];
}

void on_MainWindow_destroy(GtkObject *object, gpointer user_data)
{
	//exit the main loop
	gtk_main_quit();
}

void on_btnPushMe_clicked(GtkObject *object, gpointer user_data)
{
	printf("Button was clicked\n");

	//call Objective-C function from C function using global object pointer
	[myMainWindow printSomething];
}

@end

